/*! `logscale` grammar compiled for Highlight.js 11.7.0 */
(()=>{var e=(()=>{"use strict";return e=>{const n={
    type:["bool","byte","complex64","complex128","error","float32","float64","int8","int16","int32","int64","string","uint8","uint16","uint32","uint64","int","uint","uintptr","rune"],
    literal:["true","false","iota","nil"],
};return{name:"Logscale",aliases:["humio","Humio"],keywords:n,illegal:"</",
         contains:[e.C_LINE_COMMENT_MODE,e.C_BLOCK_COMMENT_MODE,{className:"string",
                                                                 variants:[e.QUOTE_STRING_MODE,e.APOS_STRING_MODE,{begin:"//"}]},
                   {
                       className:"number",variants:[{begin:e.C_NUMBER_RE+"[i]",relevance:1
                                                    },
                                                    e.C_NUMBER_MODE]},
                   {
                       scope: "regexp",
                       begin: "/",
                       end: "/",
                       contains: [{begin: '\\\\.'}]
                   },
                   {
                       scope: "title.function",
                       end: /\(/,
                       excludeEnd: true,
                       beginKeywords: "accumulate array:append array:contains array:dedup array:drop array:eval array:exists array:filter array:intersection array:length array:reduceAll array:reduceColumn array:reduceRow array:regex array:rename array:sort array:union asn avg base64Decode base64Encode beta:param beta:repeating bitfield:extractFlags bitfield:extractFlagsAsArray bitfield:extractFlagsAsString bucket callFunction cidr coalesce collect communityId concat concatArray copyEvent correlate count counterAsRate createEvents crypto:md5 crypto:sha1 crypto:sha256 default defineTable drop dropEvent duration end eval eventFieldCount eventInternals eventSize fieldset fieldstats findTimestamp format formatDuration formatTime geography:distance geohash getField groupBy hash hashMatch hashRewrite head if in ioc:lookup ipLocation join json:prettyPrint kvParse length linReg lower lowercase match matchAsArray math:abs math:arccos math:arcsin math:arctan math:arctan2 math:ceil math:cos math:cosh math:deg2rad math:exp math:expm1 math:floor math:log math:log10 math:log1p math:log2 math:mod math:pow math:rad2deg math:sin math:sinh math:spherical2cartesian math:sqrt math:tan math:tanh max min neighbor now objectArray:eval objectArray:exists parseCEF parseCsv parseFixedWidth parseHexString parseInt parseJson parseLEEF parseTimestamp parseUri parseUrl parseXml partition percentage percentile range rdns readFile regex rename replace reverseDns round sample sankey select selectFromMax selectFromMin selectLast selfJoin selfJoinFilter series session setField setTimeInterval shannonEntropy slidingTimeWindow slidingWindow sort split splitString start stats stdDev stripAnsiCodes subnet sum table tail test text:contains text:editDistance text:editDistanceAsArray text:endsWith text:length text:positionOf text:startsWith text:substring time:dayOfMonth time:dayOfWeek time:dayOfWeekName time:dayOfYear time:hour time:millisecond time:minute time:month time:monthName time:second time:weekOfYear time:year timeChart tokenHash top transpose unit:convert upper urlDecode urlEncode wildcard window worldMap writeJson xml:prettyPrint",
                       relevance: 1,
                   },
                   {
                       scope: "params",
                       end: /\s*=/,
                       excludeEnd: true,
                       beginKeywords: "accuracy addErrors allowTranspositions alpha array as asArray azimuth begin beta binary bits buckets by caseInsensitive caseSensitive character charset collect column columns condition confidenceThreshold current defaultBase delimiter destinationip destinationport direction distance distinct divisor duration else end endian endmatch error events exclude excludeEmpty exponent expression expressions field fields file flagNames flags format from function gamma glob globalConstraints handleNull hash header headerprefix how icmpcode icmptype ignoreCase ignoreEmpty include includeConstraintValues includeEverythingOnAsterisk includeMatchesOnceOnly index input interval ip iterationLimit jitterTolerance k keepUnit keeplabels key labelprefix lat lat1 lat2 limit live locale lon lon1 lon2 magnitude max maxDistance maxPerRoot maxduration maxpause memlimit minSpan mode multival name negate nrows occurrence on onDuplicate onlyTrue order output override parameter parsetime pattern percent percentage percentiles period pivot polar postfilter precision prefilter prefix proto query radius radix rawstring reference references regex removePrefixes repeat replaceEmpty replaceInRawstring replacement repo rest reverse root salt seed select separator separatorPadding sequence sequenceBy series server sortby source sourceip sourceport span split start startmatch step strict string strip subnet substring suffix sum target then timestampfield timezone timezoneAs timezoneField to trim type unit value values var view weight where width widths with within x y",
                       relevance: 0,
                   },
                   {
                       keywords: ["case"],
                       scope: 'built_in',
                   },
                   {
                       keywords: "= := | + / - * { } , <= >= != > <",
                       scope: 'symbol',
                       relevance: 10,
                   },
                   {
                       begin: /[^@#][a-z.A-Z_]+/,
                       end: /([, \]\)=\S]|:=)/,
                       scope: 'variable.constant',
                       excludeEnd: true,
                       relevance: 100,
                   },
                   {
                       begin: /\$"*[a-z.A-Z_]+"*/,
                       end: /([, \]\)=\S]|:=)/,
                       scope: 'variable',
                       excludeEnd: true,
                       relevance: 100,
                   },
                   {
                       begin: /[@#][a-z.A-Z_]+/,
                       end: /([-+\/*,\]\)=\S]|:=)/,
                       scope: 'title.class',
                       excludeEnd: true,
                       relevance: 100,
                   },
                   {
                       begin:/\/\//,
                       end: /$/,
                       scope: 'comment',
                   },
                   {
                       begin: /(?!$)"/,
                       end: '"',
                       scope: 'string',
                       contains: [{begin: '\\\\.'}]
                   },
                   {
                       begin: /\[/,
                       end: /\]/,
                       scope: 'operator',
                       contains: [{begin: '\\\\.'}]
                   },
                  ]}}}
            )()
      ;hljs.registerLanguage("logscale",e)})();
